//--------------
// un-tweaks
//--------------
   float4x4 World:World;

//--------------
// Textures
//--------------
   texture RenderTexture <string Name = " ";>;
   sampler RenderSampler=sampler_state 
      {
	Texture=<RenderTexture>;
  	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
	AddressU=Clamp;
	AddressV=Clamp;
	AddressW=Clamp;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
     };
   struct OutPut
     {
	float4 Pos:POSITION; 
 	float2 Tex:TEXCOORD0;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=float4(IN.Pos.x,(1.0-(World[3].x/1024.0))*2.0-1.0,0.0,1.0);
 	OUT.Tex=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+0.001953125;
	return OUT;
    }

//--------------
// pixel shader
//--------------
  float4 PS(OutPut IN) : COLOR
     {
	return tex2D(RenderSampler,IN.Tex);
     }

//--------------
// techniques   
//--------------
   technique Base
      {
 	pass p1
      {	
 	vertexShader = compile vs_3_0 VS();
 	pixelShader  = compile ps_3_0 PS();
	zwriteenable=false;
	zenable=false;
	ZFunc=always;
	fillmode=wireframe;
      }
      }
